<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class BenefitSeeder extends Seeder
{
    public function run(): void
    {
        DB::table('benefits')->insert([
            ['name' => 'Hospitalization', 'description' => 'In-patient hospitalization coverage', 'claim_type' => 'Cashless', 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['name' => 'OPD Cover', 'description' => 'Outpatient doctor consultations and treatment', 'claim_type' => 'Reimbursement', 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['name' => 'Maternity', 'description' => 'Coverage for normal delivery and C-section', 'claim_type' => 'Cashless', 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['name' => 'E-Doctor', 'description' => 'Free doctor consultation via online platform', 'claim_type' => 'Reimbursement', 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
            ['name' => 'Ambulance Cover', 'description' => 'Ambulance service coverage', 'claim_type' => 'Cashless', 'created_at' => Carbon::now(), 'updated_at' => Carbon::now()],
        ]);
    }
}
