<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('prescription_medicines', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('prescription_id');
            $table->string('medicine_name');
            $table->string('dosage'); // e.g., "1 tablet"
            $table->integer('days');  // e.g., 5
            $table->string('timing')->nullable(); // e.g., "After Breakfast"
            $table->string('time_of_day')->nullable(); // e.g., "08:00 AM"
            $table->timestamps();

            $table->foreign('prescription_id')
                  ->references('id')
                  ->on('prescriptions')
                  ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('prescription_medicines');
    }
};
