<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
            Schema::create('customer_claims', function (Blueprint $table) {
        $table->id();
        $table->string('claim_id')->unique();
        $table->foreignId('subscription_id')->constrained('insurance_subscriptions')->cascadeOnDelete();
        $table->foreignId('product_id')->constrained('products')->cascadeOnDelete();
        $table->string('customer_msisdn', 15)->index();
        $table->enum('status', ['PENDING', 'APPROVED', 'REJECTED', 'UNDER_REVIEW'])->default('PENDING');
        $table->datetime('submitted_at')->nullable();
        $table->json('images')->nullable();
        $table->text('remarks')->nullable();
        $table->timestamps();
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customer_claims');
    }
};
