<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClaimBenefit extends Model
{
    use HasFactory;

    protected $table = 'claim_benefits';

    protected $fillable = [
        'claim_id',
        'benefit_id',
        'claimed_amount',
        'approved_amount',
    ];

    // Relationships
    public function claim()
    {
        return $this->belongsTo(CustomerClaim::class, 'claim_id');
    }

    public function benefit()
    {
        return $this->belongsTo(Benefit::class, 'benefit_id');
    }
}
