<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Benefit extends Model
{
    protected $fillable = [
        'benefit_code',
        'name',
        'description',
        'claim_type',
        'icons',
    ];

    public function products(): BelongsToMany
    {
        return $this->belongsToMany(Product::class, 'product_benefits')
                    ->withPivot(['coverage_limit', 'additional_details'])
                    ->withTimestamps();
    }

    public function claims()
{
    return $this->belongsToMany(CustomerClaim::class, 'claim_benefits', 'benefit_id', 'customer_claim_id')
                ->withPivot('approved_amount')
                ->withTimestamps();
}

}
