<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Prescription;
use App\Models\Doctor;
use Illuminate\Http\JsonResponse; // ✅ correct import


class PrescriptionController extends Controller
{
    /**
     * 1. List all prescriptions for a customer by MSISDN
     */
//     public function list(Request $request)
// {
//     // dd('hi');
//     $request->validate([
//         'msisdn' => 'required|string'
//     ]);

//     $prescriptions = Prescription::with('doctor')
//         ->where('msisdn', $request->msisdn)
//         ->orderBy('date_time', 'desc')
//         ->get()
//         ->map(function ($prescription) {
//             return [
//                 'prescription_number' => $prescription->id,
//                 'type' => $prescription->type, // self_uploaded / doctor_provided
//                 'date_time' => $prescription->date_time,
//                 'doctor_name' => $prescription->doctor?->name,
//             ];
//         });

//     return response()->json($prescriptions);
// }

//   public function list(Request $request)
// {
//     $request->validate([
//         'msisdn' => 'required|string'
//     ]);

//     // Eager load doctor + medicines so mapping doesn't fire N+1 queries
//     $prescriptions = Prescription::with(['doctor', 'medicines'])
//         ->where('msisdn', $request->msisdn)
//         ->orderBy('date_time', 'desc')
//         ->get()
//       ->map(function ($prescription) {
//     $imageUrl = 'https://bangladesh.al-fajrgroup.ae/efu-health/storage/app/public/' . $prescription->image;

//     // Extension nikalne ka tariqa
//     $extension = pathinfo($prescription->image, PATHINFO_EXTENSION);

//     $item = [
//         'prescription_number' => $prescription->id,
//         'type' => $prescription->type, // self_uploaded / doctor_provided
//         'date_time' => $prescription->date_time,
//         'image' => $imageUrl,
//         'image_type' => $extension, // jpg, png, pdf etc.
//     ];

//     // Agar doctor provided hai to nested detail add karo
//     if ($prescription->type === 'doctor_provided') {
//         $item['id'] = $prescription->id;
//          'doctor_name' => $prescription->doctor_id;
//         $item['msisdn'] = $prescription->msisdn;
//         $item['prescription_number_text'] = $prescription->prescription_number ?? null;

//         $item['medications'] = $prescription->medicines->map(function ($medicine) {
//             return [
//                 'medicine_name' => $medicine->medicine_name,
//                 'dosage' => $medicine->dosage,
//                 'days' => $medicine->days,
//                 'timing' => $medicine->timing,
//                 'time_of_day' => $medicine->time_of_day,
//             ];
//         })->values();

//         $item['doctor_comment'] = $prescription->doctor_comment;
//         $item['next_follow_up'] = $prescription->next_follow_up;
//     }

//     return $item;
// });

//     return response()->json($prescriptions);
// }

// public function list(Request $request)
// {
//     //dd('hi');
//     $request->validate([
//         'msisdn' => 'required|string'
//     ]);

//     $prescriptions = Prescription::with(['doctor', 'medicines'])
//         ->where('msisdn', $request->msisdn)
//         ->orderBy('date_time', 'desc')
//         ->get()
//         ->map(function ($prescription) {

//             // Handle image safely
//             $imageData = is_string($prescription->image) ? json_decode($prescription->image, true) : $prescription->image;
//             $imagePath = is_array($imageData) ? $imageData[0] : $imageData;
//             $imageUrl = 'https://bangladesh.al-fajrgroup.ae/efu-health/storage/app/public/' . $imagePath;

//             $extension = pathinfo($imagePath, PATHINFO_EXTENSION);

//             $item = [
//                 'prescription_number' => $prescription->id,
//                 'type' => $prescription->type,
//                 'date_time' => $prescription->date_time,
//                 'image' => $imageUrl,
//                 'image_type' => $extension,
//             ];

//             if ($prescription->type === 'doctor_provided') {
//                 $item['id'] = $prescription->id;
//                 $item['doctor_name'] = $prescription->doctor ? $prescription->doctor->name : null;
//                 $item['msisdn'] = $prescription->msisdn;
//                 $item['medications'] = $prescription->medicines->map(function ($medicine) {
//                     return [
//                         'medicine_name' => $medicine->medicine_name,
//                         'dosage' => $medicine->dosage,
//                         'days' => $medicine->days,
//                         'timing' => $medicine->timing,
//                         'time_of_day' => $medicine->time_of_day,
//                     ];
//                 })->values();

//                 $item['doctor_comment'] = $prescription->doctor_comment;
//                 $item['next_follow_up'] = $prescription->next_follow_up;
//             }

//             return $item;
//         });

//     return response()->json($prescriptions);
// }


public function list(Request $request): JsonResponse
{
    $request->validate([
        'msisdn' => 'required|string'
    ]);

    // --- Google Translate function (English → Urdu) ---
    $translate = function ($text) {
        if (!empty($text)) {
            $url = 'https://translate.googleapis.com/translate_a/single?client=gtx&sl=en&tl=ur&dt=t&q=' . urlencode($text);
            $response = @file_get_contents($url);
            if ($response) {
                $result = json_decode($response, true);
                return $result[0][0][0] ?? $text;
            }
        }
        return $text;
    };

    $prescriptions = Prescription::with(['doctor', 'medicines'])
        ->where('msisdn', $request->msisdn)
        ->orderBy('date_time', 'desc')
        ->get()
        ->map(function ($prescription) use ($translate) {

            // Handle image safely
            $imageData = is_string($prescription->image) ? json_decode($prescription->image, true) : $prescription->image;
            $imagePath = is_array($imageData) ? $imageData[0] : $imageData;
            $imageUrl = 'https://bangladesh.al-fajrgroup.ae/efu-health/storage/app/public/' . $imagePath;

            $extension = pathinfo($imagePath, PATHINFO_EXTENSION);

            $item = [
                'prescription_number' => $prescription->id,
                'type' => $prescription->type,
                'date_time' => $prescription->date_time,
                'image' => $imageUrl,
                'image_type' => $extension,
            ];

            if ($prescription->type === 'doctor_provided') {
                $item['id'] = $prescription->id;
                $item['msisdn'] = $prescription->msisdn;

                // Doctor name (English + Urdu)
                $item['doctor_name'] = $prescription->doctor ? $prescription->doctor->name : null;
                $item['doctor_name_ur'] = $translate($prescription->doctor?->name ?? '');

                // Medications (English + Urdu)
                $item['medications'] = $prescription->medicines->map(function ($medicine) use ($translate) {
                    return [
                        'medicine_name' => $medicine->medicine_name,
                        'medicine_name_ur' => $translate($medicine->medicine_name ?? ''),
                        'dosage' => $medicine->dosage,
                        'dosage_ur' => $translate($medicine->dosage ?? ''),
                        'days' => $medicine->days,
                        'timing' => $medicine->timing,
                        'timing_ur' => $translate($medicine->timing ?? ''),
                        'time_of_day' => $medicine->time_of_day,
                    ];
                })->values();

                // Doctor comment (English + Urdu)
                $item['doctor_comment'] = $prescription->doctor_comment;
                $item['doctor_comment_ur'] = $translate($prescription->doctor_comment ?? '');

                $item['next_follow_up'] = $prescription->next_follow_up;
            }

            return $item;
        });

    return response()->json([
        'status' => true,
        'message' => 'Prescriptions retrieved successfully',
        'data' => $prescriptions
    ]);
}


    /**
     * 2. Upload self_uploaded prescription
     */
    // public function uploadSelfPrescription(Request $request)
    // {
        
    //     dd('hi');
    //     $request->validate([
    //         'msisdn' => 'required|string',
    //         'current_complaints' => 'required|string',
    //         'image' => 'required|image|max:2048',
    //     ]);

    //     $imagePath = $request->file('image')->store('prescriptions', 'public');

    //     $prescription = Prescription::create([
    //         'msisdn' => $request->msisdn,
    //         'type' => 'self_uploaded',
    //         'current_complaints' => $request->current_complaints,
    //         'image' => $imagePath,
    //         'date_time' => now(),
    //     ]);

    //     return response()->json([
    //         'message' => 'Self prescription uploaded successfully',
    //         'prescription' => $prescription
    //     ], 201);
    // }
    
    
//     public function uploadSelfPrescription(Request $request)
// {
//     $request->validate([
//         'msisdn'             => 'required|string',
//         'current_complaints' => 'required|string',
//         'image'              => 'required|image|max:2048', // âœ… required main image
//         'extra_images.*'     => 'nullable|image|max:2048', // âœ… optional extra images (up to 2)
//     ]);

//     // Store required main image
//     $imagePath = $request->file('image')->store('prescriptions', 'public');

//     // Create prescription
//     $prescription = Prescription::create([
//         'msisdn'             => $request->msisdn,
//         'type'               => 'self_uploaded',
//         'current_complaints' => $request->current_complaints,
//         'image'              => $imagePath,
//         'date_time'          => now(),
//     ]);

//     // Handle optional extra images
//     $extraImages = [];
//     if ($request->hasFile('extra_images')) {
//         foreach ($request->file('extra_images') as $extraImage) {
//             $path = $extraImage->store('prescriptions', 'public');
//             $extraImages[] = $path;
//         }
//     }

//     // Agar aap DB me store karna chahte ho (array/JSON column)
//     if (!empty($extraImages)) {
//         $prescription->extra_images = $extraImages; // make sure column type JSON hai
//         $prescription->save();
//     }

//     return response()->json([
//         'status'       => true,
//         'message'      => 'Self prescription uploaded successfully',
//         'prescription' => $prescription,
//         'extra_images' => $extraImages
//     ], 201);
// }


public function uploadSelfPrescription(Request $request)
{
    // dd($request->all()); // for debugging if needed

    $request->validate([
        'msisdn'             => 'required|string',
        'current_complaints' => 'required|string',
        'image'              => 'required',
        'image.*'            => 'image|max:2048', // allow multiple images in same key
    ]);

    $storedImages = [];

    // Handle one or multiple images under the same key 'image'
    if (is_array($request->file('image'))) {
        // Multiple images
        foreach ($request->file('image') as $img) {
            $path = $img->store('prescriptions', 'public');
            $storedImages[] = $path;
        }
    } else {
        // Single image
        $path = $request->file('image')->store('prescriptions', 'public');
        $storedImages[] = $path;
    }

    // Create prescription and store images as JSON
    $prescription = Prescription::create([
        'msisdn'             => $request->msisdn,
        'type'               => 'self_uploaded',
        'current_complaints' => $request->current_complaints,
        'image'              => $storedImages, // store all in JSON column
        'date_time'          => now(),
    ]);

    return response()->json([
        'status'       => true,
        'message'      => 'Self prescription uploaded successfully',
        'prescription' => $prescription,
    ], 201);
}





    /**
     * 3. Get doctor_provided prescription detail
     */
//     public function doctorPrescriptionDetail($id)
// {
//     $prescription = Prescription::with(['doctor', 'medicines'])
//         ->where('id', $id)
//         ->where('type', 'doctor_provided')
//         ->firstOrFail();

//     return response()->json([
//         'id' => $prescription->id,
//         'msisdn' => $prescription->msisdn,
//         'prescription_number' => $prescription->prescription_number,
//         'doctor_name' => $prescription->doctor?->name,
//         'medications' => $prescription->medicines->map(function ($medicine) {
//             return [
//                 'medicine_name' => $medicine->medicine_name,
//                 'dosage' => $medicine->dosage,
//                 'days' => $medicine->days,
//                 'timing' => $medicine->timing,
//                 'time_of_day' => $medicine->time_of_day,
//             ];
//         }),
//         'doctor_comment' => $prescription->doctor_comment,
//         'next_follow_up' => $prescription->next_follow_up,
//         'date_time' => $prescription->date_time,
//     ]);
// }

public function doctorPrescriptionDetail($id): JsonResponse
{
    $prescription = Prescription::with(['doctor', 'medicines'])
        ->where('id', $id)
        ->where('type', 'doctor_provided')
        ->firstOrFail();

    // --- Google Translate function (English → Urdu) ---
    $translate = function ($text) {
        if (!empty($text)) {
            $url = 'https://translate.googleapis.com/translate_a/single?client=gtx&sl=en&tl=ur&dt=t&q=' . urlencode($text);
            $response = @file_get_contents($url);
            if ($response) {
                $result = json_decode($response, true);
                return $result[0][0][0] ?? $text;
            }
        }
        return $text;
    };

    // --- Build Response ---
    return response()->json([
        'status' => true,
        'message' => 'Prescription details retrieved successfully',
        'data' => [
            'id' => $prescription->id,
            'msisdn' => $prescription->msisdn,
            'prescription_number' => $prescription->prescription_number,

            // Doctor name (English + Urdu)
            'doctor_name' => $prescription->doctor?->name,
            'doctor_name_ur' => $translate($prescription->doctor?->name ?? ''),

            // Medications (English + Urdu)
            'medications' => $prescription->medicines->map(function ($medicine) use ($translate) {
                return [
                    'medicine_name' => $medicine->medicine_name,
                    'medicine_name_ur' => $translate($medicine->medicine_name ?? ''),
                    'dosage' => $medicine->dosage,
                    'dosage_ur' => $translate($medicine->dosage ?? ''),
                    'days' => $medicine->days,
                    'timing' => $medicine->timing,
                    'timing_ur' => $translate($medicine->timing ?? ''),
                    'time_of_day' => $medicine->time_of_day,
                ];
            }),

            // Doctor comment
            'doctor_comment' => $prescription->doctor_comment,
            'doctor_comment_ur' => $translate($prescription->doctor_comment ?? ''),

            'next_follow_up' => $prescription->next_follow_up,
            'date_time' => $prescription->date_time,
        ]
    ]);
}




}
