<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\PanelHospital;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class PanelHospitalController extends Controller
{
    /**
     * Get list of hospitals sorted by distance from given lat/lng
     */
   public function index(Request $request)
{
    $latitude = $request->latitude;
    $longitude = $request->longitude;

    // Google Translate helper function
    $translate = function ($text) {
        if (!empty($text)) {
            $url = 'https://translate.googleapis.com/translate_a/single?client=gtx&sl=auto&tl=ur&dt=t&q=' . urlencode($text);
            $response = @file_get_contents($url);
            if ($response) {
                $result = json_decode($response, true);
                return $result[0][0][0] ?? $text;
            }
        }
        return $text;
    };

    $hospitals = PanelHospital::all()->map(function ($hospital) use ($latitude, $longitude, $translate) {
        $distance = $this->calculateDistance($latitude, $longitude, $hospital->latitude, $hospital->longitude);

        return [
            'id' => $hospital->id,
            'name' => $hospital->name,
            'name_ur' => $translate($hospital->name), // ✅ auto-translated Urdu name
            'available_discount' => $hospital->available_discount,
            'address' => $hospital->address,
            'contact_number' => $hospital->contact_number,
            'claims_office_number' => $hospital->claims_office_number,
            'other_information' => $hospital->other_information,
            'distance' => number_format($distance, 1) . ' km',
            'latitude' => $hospital->latitude,
            'longitude' => $hospital->longitude,
            'img' => $hospital->icon,
        ];
    });

    return response()->json([
        'status' => true,
        'message' => 'Hospitals retrieved successfully',
        'data' => $hospitals,
    ]);
}


private function calculateDistance($lat1, $lon1, $lat2, $lon2)
{
    $earthRadius = 6371; // in km

    $latFrom = deg2rad((float) $lat1);
    $lonFrom = deg2rad((float) $lon1);
    $latTo   = deg2rad((float) $lat2);
    $lonTo   = deg2rad((float) $lon2);

    $latDelta = $latTo - $latFrom;
    $lonDelta = $lonTo - $lonFrom;

    $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
        cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));

    return $earthRadius * $angle; // km
}


}
