<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Specialty;
use App\Models\Doctor;


class DoctorController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function getBySpecialty($specialty)
{
    $specialtyData = Specialty::where('name', $specialty)->firstOrFail();

    $doctors = Doctor::where('specialty_id', $specialtyData->id)
        ->where('status', 1)
        ->select('id','name', 'experience', 'location', 'rating', 'total_reviews')
        ->get()
        ->map(function($doctor) use ($specialtyData) {
            return [
                'id' => $doctor->id,
                'name' => $doctor->name,
                'category' => $specialtyData->name,
                'experience' => $doctor->experience,
                'location' => $doctor->location,
                'rating' => $doctor->rating,
                'total_reviews' => $doctor->total_reviews
            ];
        });

    return response()->json($doctors);
}

}
