<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Specialty;

class SpecialtySeeder extends Seeder
{
    public function run()
    {
        $specialties = [
            ['name' => 'ENT', 'status' => 1, 'description' => 'Ear, Nose, Throat specialist', 'icon' => 'icons/ent.png'],
            ['name' => 'Dermatology', 'status' => 1, 'description' => 'Skin specialist', 'icon' => 'icons/dermatology.png'],
            ['name' => 'Cardiology', 'status' => 1, 'description' => 'Heart specialist', 'icon' => 'icons/cardiology.png'],
            ['name' => 'Pediatrics', 'status' => 1, 'description' => 'Child specialist', 'icon' => 'icons/pediatrics.png'],
            ['name' => 'Orthopedics', 'status' => 1, 'description' => 'Bone & joint specialist', 'icon' => 'icons/orthopedics.png'],
            ['name' => 'Gynecology', 'status' => 1, 'description' => 'Women specialist', 'icon' => 'icons/gynecology.png'],
            ['name' => 'Neurology', 'status' => 1, 'description' => 'Brain & nervous system specialist', 'icon' => 'icons/neurology.png'],
            ['name' => 'Ophthalmology', 'status' => 1, 'description' => 'Eye specialist', 'icon' => 'icons/ophthalmology.png'],
            ['name' => 'Psychiatry', 'status' => 1, 'description' => 'Mental health specialist', 'icon' => 'icons/psychiatry.png'],
            ['name' => 'General Medicine', 'status' => 1, 'description' => 'General health specialist', 'icon' => 'icons/general.png'],
        ];

        foreach ($specialties as $spec) {
            Specialty::create($spec);
        }
    }
}
