<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ProductSeeder extends Seeder
{
    public function run(): void
    {
        $plans = DB::table('plans')->pluck('id', 'name');

        DB::table('products')->insert([
            [
                'plan_id' => $plans['Medical Insurance'],
                'product_name' => 'Silver - Health Plan',
                'category' => 'Annual',
                'product_code' => 'EFUH-JC-Health-Plan-Insurance-2025-Silver',
                'health_system_product_code' => 'EFUH-002-JC-2025-Silver',
                'status' => true,
                'customers' => 'JazzCash Customers Sehat+',
                'description' => 'Individual Health Insurance Exclusively for JazzCash Customer',
                'duration' => 365,
                'price' => 10000.00,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'plan_id' => $plans['Family Health Insurance'],
                'product_name' => 'Gold - Family Health Plan',
                'category' => 'Annual',
                'product_code' => 'EFUH-JC-Health-Plan-Insurance-2025-Gold',
                'health_system_product_code' => 'EFUH-003-JC-2025-Gold',
                'status' => true,
                'customers' => 'JazzCash Customers Sehat+',
                'description' => 'Family Health Insurance Exclusively for JazzCash Customer',
                'duration' => 365,
                'price' => 25000.00,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'plan_id' => $plans['Family Health Insurance'],
                'product_name' => 'Ultra - Family Health Protect',
                'category' => 'Annual',
                'product_code' => 'EFUH-JC-Ultra-Family-Health-Protect-2025',
                'health_system_product_code' => 'EFUH-004-JC-2025-Ultra',
                'status' => true,
                'customers' => 'JazzCash Customers Sehat+',
                'description' => 'Complete Family (Including Parents) Health Insurance Exclusively for JazzCash Customer',
                'duration' => 365,
                'price' => 49500.00,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ]);
    }
}
