<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Prescription;
use App\Models\PrescriptionMedicine;
use App\Models\Doctor;
use Carbon\Carbon;

class PrescriptionSeeder extends Seeder
{
    public function run(): void
    {
        // Make sure at least 1 doctor exists
        $doctor = Doctor::first();
        if (!$doctor) {
            $doctor = Doctor::create([
                'name' => 'Dr. Ali Khan',
                'category' => 'General Physician',
                'experience' => '10 years',
                'location' => 'Karachi',
                'rating' => 4.5,
                'total_reviews' => 20,
            ]);
        }

        // Self-uploaded prescription
        Prescription::create([
            'msisdn' => '923001234567',
            'type' => 'self_uploaded',
            'current_complaints' => 'Severe headache and fever',
            'image' => 'prescriptions/self_upload_1.jpg',
        ]);

        // Doctor-provided prescription
        $prescription = Prescription::create([
            'msisdn' => '923001234567',
            'type' => 'doctor_provided',
            'prescription_number' => 'RX-1001',
            'date_time' => Carbon::now(),
            'doctor_id' => $doctor->id,
            'doctor_comment' => 'Patient should take rest and drink plenty of fluids',
            'next_follow_up' => Carbon::now()->addDays(7),
        ]);

        // Medicines for doctor prescription
        PrescriptionMedicine::create([
            'prescription_id' => $prescription->id,
            'medicine_name' => 'Paracetamol',
            'dosage' => '1 tablet',
            'days' => 5,
            'timing' => 'After Breakfast',
            'time_of_day' => '08:00 AM',
        ]);

        PrescriptionMedicine::create([
            'prescription_id' => $prescription->id,
            'medicine_name' => 'Azithromycin',
            'dosage' => '1 tablet',
            'days' => 3,
            'timing' => 'After Dinner',
            'time_of_day' => '09:00 PM',
        ]);
    }
}
