<?php

// database/seeders/OffersTableSeeder.php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Offer;

class OffersTableSeeder extends Seeder
{
    public function run(): void
    {
        $offers = [
            [
                'name' => 'IDC Islamabad',
                'special_description' => 'Islamabad Diagnostic Center special healthcare discounts',
                'rating' => 4.5,
                'type' => 'Clinic',
                'code_of_type' => 'IDC-ISB',
                'latitude' => 33.6844,
                'longitude' => 73.0479,
                'offer_detail' => json_encode([
                    'discount' => '15%',
                    'services' => ['Blood Test', 'X-Ray', 'MRI']
                ]),
                'address' => 'Blue Area, Islamabad',
                'status' => 1,
            ],
            [
                'name' => 'Shifa Hospital',
                'special_description' => 'Premium healthcare offer for JazzCash customers',
                'rating' => 4.8,
                'type' => 'Hospital',
                'code_of_type' => 'SHIFA-HOSP',
                'latitude' => 33.6695,
                'longitude' => 73.0744,
                'offer_detail' => json_encode([
                    'discount' => '20%',
                    'services' => ['Emergency', 'OPD', 'Maternity']
                ]),
                'address' => 'H-8/4, Islamabad',
                'status' => 1,
            ],
            [
                'name' => 'JazzCash HQ',
                'special_description' => 'Exclusive HQ offer for employees & customers',
                'rating' => 4.7,
                'type' => 'Other',
                'code_of_type' => 'JC-HQ',
                'latitude' => 33.7105,
                'longitude' => 73.0551,
                'offer_detail' => json_encode([
                    'discount' => '10%',
                    'services' => ['Employee Special Discounts']
                ]),
                'address' => 'JazzCash HQ, F-8, Islamabad',
                'status' => 1,
            ],
        ];

        foreach ($offers as $offer) {
            Offer::create($offer);
        }
    }
}

