<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('claim_benefits', function (Blueprint $table) {
            $table->id();

            // Use claim_id instead of customer_claim_id
            $table->unsignedBigInteger('claim_id');
            $table->unsignedBigInteger('benefit_id');

            // Amounts
            $table->decimal('claimed_amount', 15, 2)->default(0);
            $table->decimal('approved_amount', 15, 2)->default(0);

            $table->timestamps();

            // Foreign keys
            $table->foreign('claim_id')->references('id')->on('customer_claims')->onDelete('cascade');
            $table->foreign('benefit_id')->references('id')->on('benefits')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('claim_benefits');
    }
};
