<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('plan_id')->constrained()->onDelete('cascade');
            $table->string('product_name');
            $table->string('category')->nullable(); // Annual, Monthly
            $table->string('product_code')->unique();
            $table->string('health_system_product_code')->unique()->nullable();
            $table->text('description')->nullable();
            $table->string('customers')->nullable();
            $table->integer('duration')->default(365); // in days
            $table->decimal('price', 12, 2);
            $table->boolean('status')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
