<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Specialty extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'status',
        'description',
        'icon',
    ];

    /**
     * Get all doctors for this specialty
     */
    public function doctors()
    {
        return $this->hasMany(Doctor::class);
    }
}

