<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProductBenefit extends Model
{
    protected $table = 'product_benefits';

    protected $fillable = [
        'product_id',
        'benefit_id',
        'coverage_limit',
        'additional_details',
    ];

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    public function benefit(): BelongsTo
    {
        return $this->belongsTo(Benefit::class);
    }
}
