<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Product extends Model
{
    protected $fillable = [
                'plan_id',
                'product_name',
                'category',
                'product_code',
                'health_system_product_code',
                'description',
                'customers',
                'duration',
                'price',
                'discounted_price',
                'status',
];

    public function plan(): BelongsTo
    {
        return $this->belongsTo(Plan::class);
    }

    public function benefits(): BelongsToMany
    {
        return $this->belongsToMany(Benefit::class, 'product_benefits')
                    ->withPivot(['coverage_limit', 'additional_details'])
                    ->withTimestamps();
    }

}
