<?php

// app/Models/Offer.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Offer extends Model
{
   // app/Models/Offer.php
    protected $fillable = [
        'name',
        'special_description', // ✅ added
        'rating',
        'type',
        'code_of_type',
        'latitude',
        'longitude',
        'offer_detail',
        'address',
        'status',
    ];


    protected $casts = [
        'offer_detail' => 'array',
    ];

    public function contacts()
    {
        return $this->hasMany(OfferContact::class);
    }

    protected $hidden = [
        'created_at',
        'updated_at',
    ];
}

