<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Doctor extends Model
{
    use HasFactory;

    protected $fillable = [
    'name',
    'email',
    'phone',
    'specialty_id',
    'qualification',
    'experience',
    'profile_image',
    'location',
    'rating',
    'total_reviews',
    'status',
];


    /**
     * Get the specialty of the doctor
     */
    public function specialty()
    {
        return $this->belongsTo(Specialty::class);
    }

    public function reviews()
{
    return $this->hasMany(DoctorReview::class);
}

}
