<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\PlanController;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\OfferController;
use App\Http\Controllers\Api\PanelHospitalController;
use App\Http\Controllers\Api\SubscriptionController;
use App\Http\Controllers\Api\CustomerClaimController;
use App\Http\Controllers\Api\SpecialtyController;
use App\Http\Controllers\Api\DoctorController;
use App\Http\Controllers\Api\DoctorReviewController;
use App\Http\Controllers\Api\PrescriptionController;
use App\Http\Controllers\Api\InsuranceBeneficiaryController;


Route::get('/plans', [PlanController::class, 'index']);


Route::get('/plans/{planId}/products', [ProductController::class, 'index']);
Route::get('/products', [ProductController::class, 'getall']);



Route::get('/offers', [OfferController::class, 'index']);
Route::get('/offers/{id}', [OfferController::class, 'show']);



Route::get('/panel-hospitals', [PanelHospitalController::class, 'index']);


Route::post('/subscriptions', [SubscriptionController::class, 'subscribe']);
Route::patch('/subscriptions/{id}/cancel', [SubscriptionController::class, 'unsubscribe']);
Route::get('/subscriptions/msisdn/{msisdn}', [SubscriptionController::class, 'activePoliciesByMsisdn']);
Route::post('/subscriptions/check-product', [SubscriptionController::class, 'hasProduct']); 


Route::get('/claims/dashboard/{msisdn}', [CustomerClaimController::class, 'dashboard']);
Route::post('/claims/submit', [CustomerClaimController::class, 'submit']);
Route::get('/claims/{msisdn}', [CustomerClaimController::class, 'listClaims']);

// List all specialties (max 20)
Route::get('/specialties', [SpecialtyController::class, 'index']);
Route::get('/doctors/{specialty}', [DoctorController::class, 'getBySpecialty']);
Route::post('/doctor/review', [DoctorReviewController::class, 'store']);


Route::get('/prescriptions', [PrescriptionController::class, 'list']);
Route::post('/prescriptions/self-upload', [PrescriptionController::class, 'uploadSelfPrescription']);
Route::get('/prescriptions/doctor/{id}', [PrescriptionController::class, 'doctorPrescriptionDetail']);


Route::post('/beneficiaries', [InsuranceBeneficiaryController::class, 'store']);
Route::get('/beneficiaries/{subscriptionId}', [InsuranceBeneficiaryController::class, 'list']);
