<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
            Schema::create('specialties', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Specialty name (e.g., ENT)
            $table->boolean('status')->default(1); // Active (1) or Inactive (0)
            $table->text('description')->nullable(); // Optional description
            $table->string('icon')->nullable(); // Icon path or URL
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('specialties');
    }
};
