<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('panel_hospitals', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('available_discount')->nullable(); // e.g. 10%, 20%
            $table->string('address');
            $table->decimal('latitude', 10, 7);
            $table->decimal('longitude', 10, 7);
            $table->string('contact_number')->nullable();
            $table->string('claims_office_number')->nullable();
            $table->text('other_information')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('panel_hospitals');
    }
};
