<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SubscriptionPaymentSuccess extends Model
{
    protected $table = 'subscription_payment_success';

    protected $fillable = [
        'subscription_id', 'transaction_id', 'amount',
        'payment_date', 'payment_method', 'reference_id', 'remarks'
    ];

    public function subscription() {
        return $this->belongsTo(InsuranceSubscription::class, 'subscription_id');
    }
}
