<?php

// app/Http/Controllers/Api/OfferController.php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Offer;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse; 

class OfferController extends Controller
{
    // 1. List Offers with distance
    public function index(Request $request): JsonResponse
    {
        $latitude = $request->get('latitude');
        $longitude = $request->get('longitude');

        $offers = Offer::select('id', 'name', 'special_description', 'rating', 'latitude', 'longitude', 'status')->get();

        // Add distance if coordinates provided
        if ($latitude && $longitude) {
            foreach ($offers as $offer) {
                $offer->distance = $this->calculateDistance($latitude, $longitude, $offer->latitude, $offer->longitude);
            }
        } else {
            foreach ($offers as $offer) {
                $offer->distance = null;
            }
        }

        // Return only required fields
        $response = $offers->map(function ($offer) {
            return [
                'id' => $offer->id,
                'name' => $offer->name,
                'special_offer' => $offer->special_description,
                'rating' => $offer->rating,
                'distance' => $offer->distance,
            ];
        });

        return response()->json([
            'status' => true,
            'message' => 'Offers retrieved successfully',
            'data' => $response
        ]);
    }


        private function calculateDistance($lat1, $lon1, $lat2, $lon2): float
    {
        $earthRadius = 6371; // Radius of Earth in KM

        $latFrom = deg2rad($lat1);
        $lonFrom = deg2rad($lon1);
        $latTo = deg2rad($lat2);
        $lonTo = deg2rad($lon2);

        $latDelta = $latTo - $latFrom;
        $lonDelta = $lonTo - $lonFrom;

        $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
                cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
        return round($earthRadius * $angle, 2); // KM with 2 decimal places
    }

    // 2. Offer Detail
        public function show($id): JsonResponse
    {
        $offer = Offer::find($id);

        if (!$offer) {
            return response()->json([
                'status' => false,
                'message' => 'Offer not found',
                'data' => []
            ], 404);
        }

        return response()->json([
            'status' => true,
            'message' => 'Offer details retrieved successfully',
            'data' => $offer
        ]);
    }
}
