<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class PlanSeeder extends Seeder
{
    public function run(): void
    {
        DB::table('plans')->insert([
            [
                'name' => 'Medical Insurance',
                'plan_code' => 'EFUH-JC-Health-Medical-Insurance-2025',
                'health_system_plan_code' => 'EFUH-001-JC-2025',
                'status' => true,
                'customers' => 'JazzCash Customers Sehat+',
                'description' => 'Individual Medical Insurance Exclusively for JazzCash Customer',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Family Health Insurance',
                'plan_code' => 'EFUL-JC-Family-Health-Insurance-2025',
                'health_system_plan_code' => 'EFUH-002-JC-2025',
                'status' => true,
                'customers' => 'JazzCash Customers Sehat+',
                'description' => 'Premium Family Health Insurance Exclusively for JazzCash Customer',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ]);
    }
}
