<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('subscription_payment_success', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('subscription_id');
            $table->string('transaction_id')->unique();
            $table->decimal('amount', 15, 2);
            $table->timestamp('payment_date')->useCurrent();
            $table->string('payment_method', 50)->default('JazzCash');
            $table->string('reference_id')->nullable();
            $table->text('remarks')->nullable();
            $table->timestamps();

            $table->foreign('subscription_id')->references('id')->on('insurance_subscriptions')->onDelete('cascade');
        });
    }

    public function down(): void {
        Schema::dropIfExists('subscription_payment_success');
    }
};
