<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('subscription_payment_failure', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('subscription_id');
            $table->decimal('attempted_amount', 15, 2);
            $table->timestamp('attempt_date')->useCurrent();
            $table->string('failure_reason');
            $table->string('error_code', 50)->nullable();
            $table->integer('retry_count')->default(0);
            $table->timestamps();

            $table->foreign('subscription_id')->references('id')->on('insurance_subscriptions')->onDelete('cascade');
        });
    }

    public function down(): void {
        Schema::dropIfExists('subscription_payment_failure');
    }
};

