<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Plan;
use Illuminate\Http\JsonResponse;

class PlanController extends Controller
{
    /**
     * Get plan with its products and product benefits
     */
    public function show($id): JsonResponse
    {
        $plan = Plan::with([
            'products.benefits' => function ($query) {
                $query->select('benefits.id', 'benefits.benefit_code', 'benefits.name', 'benefits.description', 'benefits.claim_type');
            }
        ])->find($id);

        if (!$plan) {
            return response()->json(['message' => 'Plan not found'], 404);
        }

        return response()->json([
            'plan' => $plan
        ]);
    }

      public function index(): JsonResponse
    {
        $plans = Plan::all();

        return response()->json([
            'status' => true,
            'message' => 'Plans retrieved successfully',
            'data' => $plans
        ]);
    }
}
