<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\PanelHospital;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class PanelHospitalController extends Controller
{
    /**
     * Get list of hospitals sorted by distance from given lat/lng
     */
    public function index(Request $request)
{
    $latitude = $request->latitude;
    $longitude = $request->longitude;

    $hospitals = PanelHospital::all()->map(function ($hospital) use ($latitude, $longitude) {
        $distance = $this->calculateDistance($latitude, $longitude, $hospital->latitude, $hospital->longitude);

        return [
            'id' => $hospital->id,
            'name' => $hospital->name,
            'available_discount' => $hospital->available_discount,
            'address' => $hospital->address,
            'contact_number' => $hospital->contact_number,
            'claims_office_number' => $hospital->claims_office_number,
            'other_information' => $hospital->other_information,
            'distance' => number_format($distance, 1) . ' km', // formatted distance
        ];
    });

    return response()->json([
        'status' => true,
        'message' => 'Hospitals retrieved successfully',
        'data' => $hospitals,
    ]);
}

private function calculateDistance($lat1, $lon1, $lat2, $lon2)
{
    $earthRadius = 6371; // in km

    $latFrom = deg2rad((float) $lat1);
    $lonFrom = deg2rad((float) $lon1);
    $latTo   = deg2rad((float) $lat2);
    $lonTo   = deg2rad((float) $lon2);

    $latDelta = $latTo - $latFrom;
    $lonDelta = $lonTo - $lonFrom;

    $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
        cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));

    return $earthRadius * $angle; // km
}


}
