<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DoctorReview;
use App\Models\Doctor;

class DoctorReviewController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'msisdn' => 'required|string',        // Customer phone number
            'doctor_id' => 'required|exists:doctors,id', // Doctor ID must exist
            'review' => 'nullable|string',
            'rating' => 'required|integer|min:1|max:5',
        ]);

        // Fetch the doctor instance
        $doctor = Doctor::find($request->doctor_id);

        // Create the review
        $review = DoctorReview::create([
            'doctor_id' => $doctor->id,
            'customer_id' => null,               // optional if you don’t have a customer table
            'msisdn' => $request->msisdn,
            'review' => $request->review,
            'rating' => $request->rating,
        ]);

        // Update doctor average rating and total reviews
        $doctor->total_reviews = $doctor->reviews()->count();
        $doctor->rating = round($doctor->reviews()->avg('rating'), 2);
        $doctor->save();

        return response()->json([
            'message' => 'Review added successfully',
            'review' => $review
        ], 201);
    }
}
