<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ProductBenefitSeeder extends Seeder
{
    public function run(): void
    {
        $products = DB::table('products')->pluck('id', 'product_name');
        $benefits = DB::table('benefits')->pluck('id', 'name');

        $mapping = [
            'Silver - Health Plan' => [
                ['benefit' => 'Hospitalization', 'limit' => '200,000'],
                ['benefit' => 'OPD Cover', 'limit' => '2,500'],
                ['benefit' => 'Maternity', 'limit' => '40,000'],
                ['benefit' => 'E-Doctor', 'limit' => 'Included'],
            ],
            'Gold - Family Health Plan' => [
                ['benefit' => 'Hospitalization', 'limit' => '400,000'],
                ['benefit' => 'OPD Cover', 'limit' => '5,000'],
                ['benefit' => 'Maternity', 'limit' => '80,000'],
                ['benefit' => 'Ambulance Cover', 'limit' => 'Included'],
            ],
            'Ultra - Family Health Protect' => [
                ['benefit' => 'Hospitalization', 'limit' => '600,000'],
                ['benefit' => 'OPD Cover', 'limit' => '10,000'],
                ['benefit' => 'Maternity', 'limit' => '120,000'],
                ['benefit' => 'Ambulance Cover', 'limit' => 'Included'],
            ],
        ];

        foreach ($mapping as $productName => $benefitList) {
            foreach ($benefitList as $b) {
                DB::table('product_benefits')->insert([
                    'product_id' => $products[$productName],
                    'benefit_id' => $benefits[$b['benefit']],
                    'coverage_limit' => $b['limit'],
                    'additional_details' => null,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]);
            }
        }
    }
}
