<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('insurance_beneficiaries', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('subscription_id'); // linked to InsuranceSubscription
            $table->string('name');
            $table->string('cnic')->nullable();
            $table->string('relation'); // spouse, father, mother, child
            $table->date('dob')->nullable();
            $table->string('gender')->nullable();
            $table->timestamps();

            $table->foreign('subscription_id')
                ->references('id')
                ->on('insurance_subscriptions')
                ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('insurance_beneficiaries');
    }
};
