<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('doctors', function (Blueprint $table) {
    $table->id();
    $table->string('name'); // Doctor Name
    $table->string('email')->nullable();
    $table->string('phone')->nullable();
    $table->unsignedBigInteger('specialty_id'); // Foreign key to specialties
    $table->string('qualification')->nullable();
    $table->text('experience')->nullable();
    $table->string('profile_image')->nullable();
    $table->boolean('status')->default(1); // Active or not
    $table->timestamps();

    $table->foreign('specialty_id')->references('id')->on('specialties');
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('doctors');
    }
};
