<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Doctor;
use App\Models\Specialty;

class DoctorSeeder extends Seeder
{
    public function run()
    {
        $doctors = [
            [
                'name' => 'Dr. Ahmed Khan',
                'specialty' => 'ENT',
                'experience' => '10 years',
                'location' => 'Karachi',
                'rating' => 4.5,
                'total_reviews' => 120,
                'profile_image' => 'doctors/ahmed.png'
            ],
            [
                'name' => 'Dr. Sara Malik',
                'specialty' => 'ENT',
                'experience' => '8 years',
                'location' => 'Lahore',
                'rating' => 4.7,
                'total_reviews' => 95,
                'profile_image' => 'doctors/sara.png'
            ],
            [
                'name' => 'Dr. Ali Raza',
                'specialty' => 'Dermatology',
                'experience' => '12 years',
                'location' => 'Islamabad',
                'rating' => 4.6,
                'total_reviews' => 80,
                'profile_image' => 'doctors/ali.png'
            ],
            [
                'name' => 'Dr. Ayesha Qureshi',
                'specialty' => 'Pediatrics',
                'experience' => '7 years',
                'location' => 'Karachi',
                'rating' => 4.8,
                'total_reviews' => 150,
                'profile_image' => 'doctors/ayesha.png'
            ],
            [
                'name' => 'Dr. Hassan Iqbal',
                'specialty' => 'Orthopedics',
                'experience' => '15 years',
                'location' => 'Lahore',
                'rating' => 4.4,
                'total_reviews' => 90,
                'profile_image' => 'doctors/hassan.png'
            ],
            [
                'name' => 'Dr. Sana Tariq',
                'specialty' => 'Gynecology',
                'experience' => '9 years',
                'location' => 'Islamabad',
                'rating' => 4.7,
                'total_reviews' => 110,
                'profile_image' => 'doctors/sana.png'
            ],
            [
                'name' => 'Dr. Bilal Shah',
                'specialty' => 'Neurology',
                'experience' => '11 years',
                'location' => 'Karachi',
                'rating' => 4.6,
                'total_reviews' => 75,
                'profile_image' => 'doctors/bilal.png'
            ],
            [
                'name' => 'Dr. Maria Khan',
                'specialty' => 'Ophthalmology',
                'experience' => '6 years',
                'location' => 'Lahore',
                'rating' => 4.5,
                'total_reviews' => 65,
                'profile_image' => 'doctors/maria.png'
            ],
            [
                'name' => 'Dr. Imran Ahmed',
                'specialty' => 'Psychiatry',
                'experience' => '13 years',
                'location' => 'Islamabad',
                'rating' => 4.6,
                'total_reviews' => 85,
                'profile_image' => 'doctors/imran.png'
            ],
            [
                'name' => 'Dr. Fatima Ali',
                'specialty' => 'General Medicine',
                'experience' => '10 years',
                'location' => 'Karachi',
                'rating' => 4.7,
                'total_reviews' => 140,
                'profile_image' => 'doctors/fatima.png'
            ],
        ];

        foreach ($doctors as $doc) {
            $specialty = Specialty::where('name', $doc['specialty'])->first();
            if ($specialty) {
                Doctor::create([
                    'name' => $doc['name'],
                    'specialty_id' => $specialty->id,
                    'experience' => $doc['experience'],
                    'location' => $doc['location'],
                    'rating' => $doc['rating'],
                    'total_reviews' => $doc['total_reviews'],
                    'profile_image' => $doc['profile_image'],
                    'status' => 1
                ]);
            }
        }
    }
}
