<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('prescriptions', function (Blueprint $table) {
            $table->id();
            $table->string('msisdn');
            $table->enum('type', ['self_uploaded', 'doctor_provided']);
            
            // For self_uploaded
            $table->text('current_complaints')->nullable();
            $table->string('image')->nullable();

            // For doctor_provided
            $table->string('prescription_number')->nullable();
            $table->unsignedBigInteger('doctor_id')->nullable();
            $table->foreign('doctor_id')->references('id')->on('doctors')->onDelete('set null');
            $table->json('medication_details')->nullable();
            $table->text('doctor_comment')->nullable();
            $table->date('next_follow_up')->nullable();
            $table->dateTime('date_time')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('prescriptions');
    }
};
