<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDetailsToDoctorsTable extends Migration
{
    public function up()
    {
        Schema::table('doctors', function (Blueprint $table) {
            //$table->string('experience')->nullable(); // e.g., "5 years"
            $table->string('location')->nullable();   // e.g., "Karachi"
            $table->decimal('rating', 3, 2)->default(0); // e.g., 4.5
            $table->integer('total_reviews')->default(0);
        });
    }

    public function down()
    {
        Schema::table('doctors', function (Blueprint $table) {
            $table->dropColumn(['experience', 'location', 'rating', 'total_reviews']);
        });
    }
}
