<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('insurance_subscriptions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('policy_id')->unique();
            $table->timestamp('subscription_timestamp')->useCurrent();
            $table->unsignedBigInteger('plan_id');
            $table->unsignedBigInteger('product_id');
            $table->decimal('amount', 15, 2);
            $table->enum('payment_frequency', ['DAILY','MONTHLY','ANNUAL','INSTALLMENT']);
            $table->json('installment_details')->nullable();
            $table->string('customer_msisdn', 15)->index();
            $table->string('customer_name');
            $table->string('customer_cnic', 15)->index();
            $table->string('jazzcash_tid')->unique();
            $table->string('jazzcash_reference_id')->nullable();
            $table->date('next_charging_date')->index();
            $table->enum('status', ['ACTIVE','PENDING','SUSPENDED','LAPSED','CANCELLED'])->default('ACTIVE');
            $table->date('last_charged_date')->nullable();
            $table->timestamps();

            $table->foreign('plan_id')->references('id')->on('plans')->onDelete('cascade');
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
        });
    }

    public function down(): void {
        Schema::dropIfExists('insurance_subscriptions');
    }
};

