<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SubscriptionPaymentFailure extends Model
{
    protected $table = 'subscription_payment_failure';

    protected $fillable = [
        'subscription_id', 'attempted_amount', 'attempt_date',
        'failure_reason', 'error_code', 'retry_count'
    ];

    public function subscription() {
        return $this->belongsTo(InsuranceSubscription::class, 'subscription_id');
    }
}

