<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Prescription extends Model
{
    use HasFactory;

    protected $fillable = [
        'msisdn',
        'type',
        'current_complaints',
        'image',
        'prescription_number',
        'doctor_id',
        'medication_details',
        'doctor_comment',
        'next_follow_up',
        'date_time',
    ];

    protected $casts = [
        'medication_details' => 'array',
         'image' => 'array',
    ];

    public function doctor()
    {
        return $this->belongsTo(Doctor::class);
    }

    public function medicines()
   {
    return $this->hasMany(PrescriptionMedicine::class);
   }




}
