<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Plan extends Model
{
    protected $fillable = [
        'name',
        'plan_code',
        'health_system_plan_code',
        'description',
        'customers',
        'status'
    ];

    public function products(): HasMany
    {
        return $this->hasMany(Product::class);
    }

    protected $hidden = [
        'created_at',
        'updated_at',
    ];
}
