<?php

// app/Models/Offer.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Offer extends Model
{
   // app/Models/Offer.php
    protected $fillable = [
        'name',
        'special_description', // ✅ added
        'rating',
        'type',
        'code_of_type',
        'latitude',
        'longitude',
        'offer_detail',
        'address',
        'status',
        'icon'
    ];


    protected $casts = [
        'offer_detail' => 'array',
    ];


  
    // Agar sirf services array chahiye
    public function getOfferDetailAttribute($value)
    {
        $decoded = json_decode($value, true);

        if (isset($decoded['services'])) {
            return $decoded['services']; // sirf services array
        }

        return $decoded; // warna pura decoded object return karo
    }
    
    
    public function contacts()
    {
        return $this->hasMany(OfferContact::class);
    }

    protected $hidden = [
        'created_at',
        'updated_at',
    ];
}

