<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class InsuranceSubscription extends Model
{
    protected $fillable = [
        'policy_id', 'plan_id', 'product_id', 'amount', 'payment_frequency',
        'installment_details', 'customer_msisdn', 'customer_name', 'customer_cnic','actual_amount',
        'jazzcash_tid', 'jazzcash_reference_id', 'next_charging_date', 'status', 'last_charged_date'
    ];

    protected $casts = [
        'installment_details' => 'array'
    ];

    public function paymentSuccess() {
        return $this->hasMany(SubscriptionPaymentSuccess::class, 'subscription_id');
    }

    public function paymentFailure() {
        return $this->hasMany(SubscriptionPaymentFailure::class, 'subscription_id');
    }

    public function beneficiaries()
{
    return $this->hasMany(InsuranceBeneficiary::class, 'subscription_id');
}

}

