<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerClaim extends Model
{
    use HasFactory;

    protected $table = 'customer_claims';

    protected $fillable = [
        'claim_id',
        'subscription_id',
        'product_id',
        'customer_msisdn',
        'status',
        'submitted_at',
        'images',
        'remarks',
    ];

    protected $casts = [
        'images' => 'array',
        'submitted_at' => 'datetime',
    ];

    // Relationships
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    // public function benefits()
    // {
    //     return $this->belongsToMany(Benefit::class, 'claim_benefits')
    //                 ->withPivot('claimed_amount', 'approved_amount')
    //                 ->withTimestamps();
    // }

    public function subscription()
    {
        return $this->belongsTo(InsuranceSubscription::class, 'subscription_id');
    }

    public function benefits()
{
    return $this->belongsToMany(Benefit::class, 'claim_benefits', 'claim_id', 'benefit_id')
                ->withPivot('claimed_amount', 'approved_amount')
                ->withTimestamps();
}
}

