<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\CustomerClaim;
use Illuminate\Http\JsonResponse;
use App\Models\Product;
use App\Models\Benefit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;

class CustomerClaimController extends Controller
{
// public function dashboard($msisdn): JsonResponse
// {
//     $claims = CustomerClaim::with(['product.benefits', 'benefits'])
//         ->where('customer_msisdn', $msisdn)
//         ->get();

//     $grouped = $claims->groupBy(fn($claim) => $claim->product->id);

//     $data = $grouped->map(function ($claimsGroup) {
//         $product = $claimsGroup->first()->product;
       

//         $benefits = collect();

//         foreach ($claimsGroup as $claim) {
//             foreach ($claim->benefits as $benefit) {
//                 $total_amount = $product->benefits
//                     ->firstWhere('id', $benefit->id)
//                     ->pivot
//                     ->coverage_limit ?? 0;

//                 if (!$benefits->has($benefit->id)) {
//                     $benefits->put($benefit->id, [
//                         'name' => $benefit->name,
//                         'total_amount' => $total_amount,
//                         'utilized_amount' => $benefit->pivot->approved_amount ?? 0,
                       
//                     ]);
//                 } else {
//                     $benefits[$benefit->id]['utilized_amount'] += $benefit->pivot->approved_amount ?? 0;
//                 }
//             }
//         }

//         return [
//             'product_name' => $product->product_name,
//             'benefits' => $benefits->values(),
//         ];
//     });

//     return response()->json([
//         'status' => true,
//         'message' => 'Customer claims dashboard retrieved successfully',
//         'data' => $data->values(),
//     ]);
// }

// public function dashboard($msisdn): JsonResponse
// {
    
//     // dd('hi');
//     $claims = CustomerClaim::with([
//         'product.plan',
//         'product.benefits',
//         'benefits'
//     ])
//     ->where('customer_msisdn', $msisdn)
//     ->get();

//     $grouped = $claims->groupBy(fn($claim) => $claim->product->id);

//     $data = $grouped->map(function ($claimsGroup) {
//         $product = $claimsGroup->first()->product;
//         $plan = $product->plan;

//         $benefits = collect();

//         foreach ($claimsGroup as $claim) {
//             foreach ($claim->benefits as $benefit) {
//                 $total_amount = $product->benefits
//                     ->firstWhere('id', $benefit->id)
//                     ->pivot
//                     ->coverage_limit ?? 0;

//                 if (!$benefits->has($benefit->id)) {
//     $benefits->put($benefit->id, [
//         'name'            => $benefit->name,
//         'total_amount'    => $total_amount,
//         'icon'            => $benefit->icon,
//         'utilized_amount' => $benefit->pivot->approved_amount ?? 0,
//     ]);
// } else {
//     $existing = $benefits->get($benefit->id);
//     $existing['utilized_amount'] += $benefit->pivot->approved_amount ?? 0;
//     $benefits->put($benefit->id, $existing);
// }

//             }
//         }

//         // Agar latest claim ka status lena hai
//         $latestClaimStatus = $claimsGroup->last()->status ?? 'Pending';

//         return [
//             'product_id'   => $product->id,
//             'plan_id'      => $plan->id ?? null,
//             'product_name' => $product->product_name,
//             'plan_name'    => $plan->name ?? null,
//             'benefits'     => $benefits->values(),
//             'claim_status' => $latestClaimStatus,
//         ];
//     });

//     return response()->json([
//         'status'  => true,
//         'message' => 'Customer claims dashboard retrieved successfully',
//         'data'    => $data->values(),
//     ]);
// }


public function dashboard($msisdn): JsonResponse
{
    $claims = CustomerClaim::with([
        'product.plan',
        'product.benefits',
        'benefits'
    ])
    ->where('customer_msisdn', $msisdn)
    ->get();

    // Google Translate helper function
    $translate = function ($text) {
        if (!empty($text)) {
            $url = 'https://translate.googleapis.com/translate_a/single?client=gtx&sl=auto&tl=ur&dt=t&q=' . urlencode($text);
            $response = @file_get_contents($url);
            if ($response) {
                $result = json_decode($response, true);
                return $result[0][0][0] ?? $text;
            }
        }
        return $text;
    };

    // Filter out claims without related product
    $grouped = $claims->filter(function ($claim) {
        return $claim->product !== null;
    })->groupBy(function ($claim) {
        return $claim->product->id;
    });

    $data = $grouped->map(function ($claimsGroup) use ($translate) {
        $product = $claimsGroup->first()->product;
        if (!$product) {
            return null; // skip invalid group
        }

        $plan = $product->plan;
        $benefits = collect();

        foreach ($claimsGroup as $claim) {
            foreach ($claim->benefits as $benefit) {
                $total_amount = $product->benefits
                    ->firstWhere('id', $benefit->id)
                    ->pivot
                    ->coverage_limit ?? 0;

                if (!$benefits->has($benefit->id)) {
                    $benefits->put($benefit->id, [
                        'name'            => $benefit->name,
                        'name_ur'         => $translate($benefit->name), // ✅ auto-translated Urdu
                        'total_amount'    => $total_amount,
                        'icon'            => $benefit->icon,
                        'utilized_amount' => $benefit->pivot->approved_amount ?? 0,
                    ]);
                } else {
                    $existing = $benefits->get($benefit->id);
                    $existing['utilized_amount'] += $benefit->pivot->approved_amount ?? 0;
                    $benefits->put($benefit->id, $existing);
                }
            }
        }

        $latestClaimStatus = $claimsGroup->last()->status ?? 'Pending';

        return [
            'subscription_id' => $claimsGroup->first()->subscription_id,
            'product_id'      => $product->id,
            'plan_id'         => $plan->id ?? null,
            'product_name'    => $product->product_name,
            'plan_name'       => $plan->name ?? null,
            'benefits'        => $benefits->values(),
            'claim_status'    => $latestClaimStatus,
        ];
    })->filter(); // remove nulls

    return response()->json([
        'status'  => true,
        'message' => 'Customer claims dashboard retrieved successfully',
        'data'    => $data->values(),
    ]);
}



    // public function submit(Request $request): JsonResponse
    // {
    //     // Validate request
    //     $validator = Validator::make($request->all(), [
    //         'customer_msisdn' => 'required|string|max:15',
    //         'subscription_id' => 'required|integer|exists:insurance_subscriptions,id',
    //         'product_id'      => 'required|integer|exists:products,id',
    //         'images.*'        => 'required|image|mimes:jpeg,png,jpg,gif|max:5120', // max 5MB per image
    //     ]);

    //     if ($validator->fails()) {
    //         return response()->json([
    //             'status'  => false,
    //             'message' => $validator->errors()->first(),
    //             'data'    => []
    //         ], 422);
    //     }

    //     // Create claim
    //     $claim = CustomerClaim::create([
    //         'claim_id'         => 'CLM-' . time(),
    //         'customer_msisdn'  => $request->customer_msisdn,
    //         'subscription_id'  => $request->subscription_id,
    //         'product_id'       => $request->product_id,
    //         'status'           => 'PENDING',
    //         'submitted_at'     => now(),
    //     ]);

    //     // Handle image uploads
    //     $images = [];
    //     if ($request->hasFile('images')) {
    //         foreach ($request->file('images') as $image) {
    //             $path = $image->store('claims', 'public');
    //             $images[] = $path;
    //         }
    //         $claim->images = $images;
    //         $claim->save();
    //     }

    //     // Attach benefits (optional: initialize utilized_amount to 0)
    //     $product = Product::find($request->product_id);
    //     if ($product && $product->benefits) {
    //         foreach ($product->benefits as $benefit) {
    //             $claim->benefits()->attach($benefit->id, ['approved_amount' => 0]);
    //         }
    //     }

    //     return response()->json([
    //         'status'  => true,
    //         'message' => 'Claim submitted successfully',
    //         'data'    => [
    //             'claim_id' => $claim->claim_id,
    //             'status'   => $claim->status,
    //             'images'   => $images
    //         ]
    //     ]);
    // }


public function submit(Request $request): JsonResponse
{
    try {
        // Validate request
        $validator = Validator::make($request->all(), [
            'customer_msisdn' => 'required|string|max:15',
            'subscription_id' => 'required|integer|exists:insurance_subscriptions,id',
            'product_id'      => 'nullable|integer|exists:products,id', // ✅ optional
            'images.*'        => 'required|image|mimes:jpeg,png,jpg,gif|max:5120', // max 5MB per image
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status'  => false,
                'message' => $validator->errors()->first(),
                'data'    => []
            ], 422);
        }

        // Create claim
        $claim = CustomerClaim::create([
            'claim_id'         => 'CLM-' . time(),
            'customer_msisdn'  => $request->customer_msisdn,
            'subscription_id'  => $request->subscription_id,
            'product_id'       => $request->product_id ?? null, // ✅ null if not provided
            'status'           => 'PENDING',
            'submitted_at'     => now(),
        ]);

        // Handle image uploads
        $images = [];
        if ($request->hasFile('images')) {
            foreach ($request->file('images') as $image) {
                $path = $image->store('claims', 'public');
                $images[] = $path;
            }
            $claim->images = $images;
            $claim->save();
        }

        // Attach benefits (only if product_id is provided)
        if ($request->filled('product_id')) {
            $product = Product::find($request->product_id);
            if ($product && $product->benefits) {
                foreach ($product->benefits as $benefit) {
                    $claim->benefits()->attach($benefit->id, ['approved_amount' => 0]);
                }
            }
        }

        return response()->json([
            'status'  => true,
            'message' => 'Claim submitted successfully',
            'data'    => [
                'claim_id'    => $claim->claim_id,
                'status'      => $claim->status,
                'product_id'  => $claim->product_id, // ✅ return null if not provided
                'images'      => $images
            ]
        ]);

    } catch (\Exception $e) {
        return response()->json([
            'status'  => false,
            'message' => 'Something went wrong',
            'error'   => $e->getMessage(),
        ], 500);
    }
}



//   public function listClaims(Request $request, $msisdn): JsonResponse
// {
    
//      dd('hi');
//     // Validate filter
//     $status = $request->query('status'); // approved, pending, etc.

//     $query = CustomerClaim::with(['product.plan'])
//         ->where('customer_msisdn', $msisdn);

//     if ($status) {
//         $query->where('status', strtoupper($status)); // make sure status matches DB
//     }

//     $claims = $query->get();

//     $data = $claims->map(function ($claim) {
//         $product = $claim->product;
//         $plan = $product->plan ?? null;

//         return [
//             'claim_id'     => $claim->claim_id,
//             'submitted_at' => $claim->submitted_at,
//             'product_id'   => $product->id ?? null,
//             'plan_id'      => $plan->id ?? null,
//             'product_name' => $product->product_name ?? null,
//             'plan_name'    => $plan->name ?? null,
//             'status'       => $claim->status,
//         ];
//     });

//     return response()->json([
//         'status'  => true,
//         'message' => 'Customer claims retrieved successfully',
//         'data'    => $data,
//     ]);
// }


// public function listClaims(Request $request, $msisdn): JsonResponse
// {
//     try {
//         // ✅ Validation
//         $validated = $request->validate([
//             'status'   => 'required|string|in:approved,pending,rejected,all', // allowed statuses
//             'plan_id'  => 'required|integer|exists:plans,id', // check plan id exists
//         ]);

//         $status = strtoupper($validated['status']);
//         $planId = $validated['plan_id'];

//         $query = CustomerClaim::with(['product.plan'])
//             ->where('customer_msisdn', $msisdn)
//             ->where('status', $status)
//             ->whereHas('product.plan', function ($q) use ($planId) {
//                 $q->where('id', $planId);
//             });

//         $claims = $query->get();

//         $data = $claims->map(function ($claim) {
//             $product = $claim->product;
//             $plan    = $product->plan ?? null;

//             return [
//                 'claim_id'     => $claim->claim_id,
//                 'submitted_at' => $claim->submitted_at,
//                 'product_id'   => $product->id ?? null,
//                 'plan_id'      => $plan->id ?? null,
//                 'product_name' => $product->product_name ?? null,
//                 'plan_name'    => $plan->name ?? null,
//                 'status'       => $claim->status,
//             ];
//         });

//         return response()->json([
//             'status'  => true,
//             'message' => 'Customer claims retrieved successfully',
//             'data'    => $data,
//         ]);
//     } catch (\Illuminate\Validation\ValidationException $e) {
//         // ❌ Validation error response
//         return response()->json([
//             'status'  => false,
//             'message' => 'Validation failed',
//             'errors'  => $e->errors(),
//         ], 422);
//     } catch (\Exception $e) {
//         // ❌ General error response
//         return response()->json([
//             'status'  => false,
//             'message' => 'Something went wrong',
//             'error'   => $e->getMessage(),
//         ], 500);
//     }
// }

public function listClaims(Request $request, $msisdn): JsonResponse
{
    try {
        // ✅ Validation
        $validated = $request->validate([
            'status'   => 'required|string|in:approved,pending,rejected,all', // allowed statuses
            'plan_id'  => 'required|integer|exists:plans,id', // check plan id exists
        ]);

        $status = strtolower($validated['status']);
        $planId = $validated['plan_id'];

        $query = CustomerClaim::with(['product.plan'])
            ->where('customer_msisdn', $msisdn)
            ->whereHas('product.plan', function ($q) use ($planId) {
                $q->where('id', $planId);
            });

        // ✅ Apply status filter only if not "all"
        if ($status !== 'all') {
            $query->where('status', strtoupper($status));
        }

        $claims = $query->get();

        $data = $claims->map(function ($claim) {
            $product = $claim->product;
            $plan    = $product->plan ?? null;

            return [
                'claim_id'     => $claim->claim_id,
                'submitted_at' => $claim->submitted_at,
                'product_id'   => $product->id ?? null,
                'plan_id'      => $plan->id ?? null,
                'product_name' => $product->product_name ?? null,
                'plan_name'    => $plan->name ?? null,
                'status'       => $claim->status,
            ];
        });

        return response()->json([
            'status'  => true,
            'message' => $status === 'all'
                ? 'All customer claims retrieved successfully'
                : 'Customer claims retrieved successfully',
            'data'    => $data,
        ]);
    } catch (\Illuminate\Validation\ValidationException $e) {
        // ❌ Validation error response
        return response()->json([
            'status'  => false,
            'message' => 'Validation failed',
            'errors'  => $e->errors(),
        ], 422);
    } catch (\Exception $e) {
        // ❌ General error response
        return response()->json([
            'status'  => false,
            'message' => 'Something went wrong',
            'error'   => $e->getMessage(),
        ], 500);
    }
}




}
