<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class CheckAgentSession
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        Log::info('Middleware is being called');
        if (!Auth::guard('agent')->check()) {
            return redirect()->route('agent.login')->withErrors(['login' => 'Please log in first.']);
        }
        if (!Auth::guard('admin')->check()) {
            return redirect()->route('agent.login')->withErrors(['login' => 'Please log in first.']);
        }

        return $next($request);
    }

}
