<?php

namespace App\Http\Controllers\agent;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Plans;
use App\Models\Products;
use App\Models\Categories;
use App\Models\MerchantInformation;
use App\Models\CheckingRequest;
use App\Models\Subscription;
use App\Models\Inquary;
use App\Models\FailedSubscriptions;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Log;

class SubscriptionsController extends Controller
{
    public function create()
    {
        $categories = Categories::get();
        $plans = Plans::where('is_active',1)->get();
        $products = Products::get();
        return view('agents.subscriptions.create',compact('categories','plans','products'));
    }

    private function calculateSecureHash($shared_secret, $data) {
        return strtoupper(hash_hmac('sha256', $data, $shared_secret));
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $validator = Validator::make($request->all(), [
            'agent_id' => 'required',
            'customer_msisdn' => 'required',
            'product_category_id' => 'required',
            'planid' => 'required',
            'product_id' => 'required',
        ]);

         if ($validator->fails()) {
             return response()->json(['status' => 'failed', 'message' => "One Or More Fields Have an Validator Error. Please Check and Try Again"]);

         }

         $today = Carbon::today();
         $checking_request_number  = CheckingRequest::where('msisdn',$request->customer_msisdn)
         ->whereDate('created_at', $today)->first();
     //    dd($checking_request_number);

      if (!empty($checking_request_number->msisdn)) {
          $checking_number = $checking_request_number->msisdn;
       }
       else{
         $checking_number="";
       }
         //  dd($checking_number);
           if(!empty($request->customer_msisdn == $checking_number)){
             //   dd('hi');
             if ($checking_request_number->request_number < 5) {
               $checking_request = CheckingRequest::find($checking_request_number->id);
               $checking_request->request_number++;
               $checking_request->update();
             }

           }
           else{
             // dd('by');
                 $checking_request   = new CheckingRequest();
                 $checking_request->msisdn = $request->customer_msisdn;
                 $checking_request->request_number = "1";
                 $checking_request->save();
                 // dd($checking_request);
           }
           $checking_request_count  = CheckingRequest::where('msisdn',$request->customer_msisdn)
           ->whereDate('created_at', $today)->first();
       if (!empty($checking_request_count->request_number < 5)) {

        $products = Products::where('product_id', $request->product_id)->first();
        $plan = Plans::where('planid', $request->planid)->first();
         $merchant_Information = MerchantInformation::orderBy('created_at', 'desc')->where('payment_pulse','non-recursive')->first();
         $merchant_Information_id = $merchant_Information->merchant_id;

        $plan_name = $plan->plan_name;
        $value = $products->price;
        $amount  = number_format($value, 0, '.', '');
        //  dd($amount);
        $shared_secret = '1x0t013t9w';
        $currentDateTime = now()->format('YmdHis');
        $expiryDateTime = now()->addMinutes(2)->format('YmdHis');

        $data = [
            "pp_Version" => "1.1",
            "pp_TxnType" => "MWALLET",
            "pp_Language" => "EN",
            "pp_MerchantID" => "MC97555",
            "pp_SubMerchantID" => "",
            "pp_Password" => "v23s20b1tv",
            "pp_BankID" => "",
            "pp_ProductID" => "",
            "pp_TxnRefNo" => (string)rand(10000000000000000, 99999999999999999),
            "pp_Amount" => $amount,
            "pp_TxnCurrency" => "PKR",
            "pp_TxnDateTime" => $currentDateTime,
            "pp_BillReference" => "billref",
            "pp_Description" => "Insurance",
            "pp_TxnExpiryDateTime" => $expiryDateTime,
            "pp_ReturnURL" => "www.efulife.com",
            "ppmpf_1" => $request->customer_msisdn,
            "ppmpf_2" => "",
            "ppmpf_3" => "",
            "ppmpf_4" => "",
            "ppmpf_5" => ""
        ];

        ksort($data);

        $hash_string = '';
        foreach ($data as $key => $value) {
            if ((strpos($key, 'pp_') === 0 || strpos($key, 'ppmpf_') === 0) && $value !== '') {
                $hash_string .= '&' . $value;
            }
        }

        $hash_string = $shared_secret . $hash_string;
        $hash_string = utf8_encode($hash_string);
        $hash_string = mb_convert_encoding($hash_string, 'ISO-8859-1', 'UTF-8');

        $data['pp_SecureHash'] = $this->calculateSecureHash($shared_secret, $hash_string);

        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post('https://sandbox.jazzcash.com.pk/ApplicationAPI/API/Payment/DoTransaction', $data);

           // Logs
          Log::channel('non_recusive_api')->info('Non Recusive Api Logs.',[
            'Msisdn-number' =>  $request->customer_msisdn,
             'request-packet' => $data,
            'response-data' => $response,
            ]);

        $res = $response['pp_ResponseCode'];
        // dd($res);
        // $response = json_decode($response, true);
        //   dd($response);
        $message = $response['pp_ResponseMessage'];
        $TransactionID = $response['pp_TxnDateTime'];
        $Reason = $response['pp_ResponseMessage'];
        if ($res == "000") {
            $subscription = new Subscription();
            $subscription->customer_msisdn = $request->customer_msisdn;
            $subscription->planid = $request->planid;
            $subscription->product_category_id = $request->product_category_id;
            $subscription->product_id = $request->product_id;
            $subscription->transaction_amount = $amount;
            $subscription->subscription_time = now();
            $subscription->jc_response_code = $response['pp_ResponseCode'];
            $subscription->jc_response_message = $response['pp_ResponseMessage'];
            $subscription->jc_amount = $response['pp_Amount'];
            $subscription->payment_pulse = "non-recursive";
            $subscription->jc_merchantId = $response['pp_MerchantID'];
            $subscription->jc_RetreivalReferenceNo = $response['pp_RetreivalReferenceNo'];
            $subscription->transaction_reference_id = $response['pp_TxnRefNo'];
            $subscription->transaction = $response['pp_TxnDateTime'];
            $subscription->policy_status = "1";
            $subscription->settlement_expiry_time = $response['pp_SettlementExpiry'];
            $subscription->agent_id = $request->agent_id;
            $subscription->merchant_id = $merchant_Information_id;
            $subscription->save();

              // Sms Delivary Code;
           $url = 'https://api.efulife.com/itssr/its_sendsms';
           $payload = [
             'MobileNo' => $request->customer_msisdn,
             'sender' => 'Jazz_Cash_Portal',
             'SMS' => "Dear Customer, You have successfully subscribed {$plan_name} for Rs {$amount}. ",
               ];
           $headers = [
            'Channelcode' => 'ITS',
            'Authorization' => 'Bearer XXXXAAA123BBCITSSMS',
            'Content-Type' => 'application/json',
            ];
           $response = Http::withHeaders($headers)->post($url, $payload);
          // End Sms Delivary Code;

            $customMessage = '<span style="color: #697a8d; font-size: 25px;">Transaction Status: </span><span style="color: #66c732; font-size: 25px;">Success!</span><br><span style="color: #697a8d; font-size: 25px;">Sale Status: </span><span style="color: #66c732; font-size: 25px;">Confirmed</span>
            <br> <span> Transaction Information: '  .$TransactionID. '<br>JazzCash Response: <span style="color: #66c732;">' .$Reason.'</span> </span>' ;

          return response()->json(['status' => 'successfully', 'message' => $customMessage . ' ' . $message]);


        }
        if ($res == "002") {

            $Inquary = new Inquary();
            $Inquary->customer_msisdn = $request->customer_msisdn;
            $Inquary->planid = $request->planid;
            $Inquary->product_category_id = $request->product_category_id;
            $Inquary->product_id = $request->product_id;
            $Inquary->transaction_amount = $amount;
            $Inquary->Inquary_time = now();
            $Inquary->jc_response_code = $response['pp_ResponseCode'];
            $Inquary->jc_response_message = $response['pp_ResponseMessage'];
            $Inquary->payment_pulse = "non-recursive";
            $Inquary->jc_merchantId = $response['pp_MerchantID'];
            $Inquary->jc_RetreivalReferenceNo = $response['pp_RetreivalReferenceNo'];
            $Inquary->transaction_reference_id = $response['pp_TxnRefNo'];
            $Inquary->transaction = $response['pp_TxnDateTime'];
            $Inquary->status = "0";
            $Inquary->agent_id = $request->agent_id;
            $Inquary->merchant_id = $merchant_Information_id;
            $Inquary->save();

            $customMessage = '<span style="color: #697a8d; font-size: 25px;">Transaction Status: </span><span style="color: #ff9999; font-size: 25px;">Jazz Inquiry Api  :(</span><br><span style="color: #697a8d; font-size: 25px;">Sale Status: </span><span style="color: #ff9999; font-size: 25px;">Failed</span>
            <br> <span> Transaction Information: ' . $TransactionID.  '<br>Failed Reason:  <span style="color: #ff9999;"> ' .$Reason.  '</span> </span>' ;
             return response()->json(['status' => 'failed', 'message' => $customMessage . ' ' . $message]);

            }
        else{

            $failed_subscriptions = new FailedSubscriptions();
            $failed_subscriptions->customer_msisdn = $request->customer_msisdn;
            $failed_subscriptions->planid = $request->planid;
            $failed_subscriptions->product_category_id = $request->product_category_id;
            $failed_subscriptions->product_id = $request->product_id;
            $failed_subscriptions->amount = $amount;
            $failed_subscriptions->jc_response_code = $response['pp_ResponseCode'];
            $failed_subscriptions->jc_response_message = $response['pp_ResponseMessage'];
            $failed_subscriptions->payment_pulse = "non-recursive";
            $failed_subscriptions->jc_merchantId = $response['pp_MerchantID'];
            $failed_subscriptions->jc_RetreivalReferenceNo = $response['pp_RetreivalReferenceNo'];
            $failed_subscriptions->reference_id = $response['pp_TxnRefNo'];
            $failed_subscriptions->transaction_id = $response['pp_TxnDateTime'];
            $failed_subscriptions->type = $response['pp_TxnType'];
            $failed_subscriptions->source = "portal";
            $failed_subscriptions->company_id = "11";
            $failed_subscriptions->agent_id = $request->agent_id;
            $failed_subscriptions->sale_request_time = now();
            $failed_subscriptions->merchant_id = $merchant_Information_id;
            $failed_subscriptions->save();
            // dd($failed_subscriptions);



            $customMessage = '<span style="color: #697a8d; font-size: 25px;">Transaction Status: </span><span style="color: #ff9999; font-size: 25px;">Failed :(</span><br><span style="color: #697a8d; font-size: 25px;">Sale Status: </span><span style="color: #ff9999; font-size: 25px;">Failed</span>
            <br> <span> Transaction Information: ' . $TransactionID.  '<br>Failed Reason:  <span style="color: #ff9999;"> ' .$Reason.  '</span> </span>' ;

             return response()->json(['status' => 'failed', 'message' => $customMessage . ' ' . $message]);
        }

 }
 else{


    $customMessage = '<span style="color: #697a8d; font-size: 25px;">MPIN Request Limit Exceed </span>
    <br> <span> As Per Jazzcash, You Have Exceeds the Number of M-PINs Request to This Number, Kindly Try Again After 24 Hours. </span>' ;

     return response()->json(['status' => 'failed', 'message' => $customMessage ]);

 }

}




     public function getCategoriesByPlan(Request $request)
      {
            $planid = $request->input('planid');

             // Fetch categories based on planid
             $categories = Categories::where('plan_id', $planid)->get();

           return response()->json(['categories' => $categories]);
       }


    public function getProductsByPlan(Request $request)
    {
        $category_id = $request->input('category_id');
        // Query products based on planid and category_id
        $products = Products::where('product_category_id', $category_id)
                           ->get(['product_id', 'product_name']);

        return response()->json(['products' => $products]);
    }




    public function checksub(Request $request)
    {

        //   dd($request->all());
         $msisdn = $request->input('msisdn');
         $planid = $request->input('planid');

        // // Retrieve records with Plan ID 1 for the given msisdn
        $SubscriptionData = Subscription::where('customer_msisdn', $msisdn)->where('planid', $planid)->where('policy_status', 1)->first();

        //   dd($SubscriptionData);
        // // Return the data as JSON to the frontend
        if ($SubscriptionData) {
            return response()->json(['success' => true]); // Record exists
        } else {
            return response()->json(['success' => false]); // Record does not exist
        }

    }


}
