<?php

namespace App\Http\Controllers\agent;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Plans;
use App\Models\Products;
use App\Models\Categories;
use App\Models\Subscription;
use App\Models\FailedSubscriptions;
use Illuminate\Support\Str;
use Yajra\DataTables\DataTables;

class ReportController extends Controller
{
    public function failedreport(Request $request)
    {
        $agent = session('agent');
        $agentId = $agent->id;
        if ($request->ajax()) {
            $data = FailedSubscriptions::select('*')->where('agent_id',$agentId)->orderBy('created_at', 'desc');
            return Datatables::of($data)->addIndexColumn()

                    ->addColumn('product_category_name', function($data){
                        return $data->categories ? $data->categories->category_name : 'N/A'; // Assuming 'name' is a field in Categories
                    })
                    ->addColumn('planname', function($data){
                        return $data->plan ? $data->plan->plan_name : 'N/A'; // Assuming 'name' is a field in Plans
                    })
                    ->addColumn('productname', function($data){
                        return $data->products ? $data->products->product_name : 'N/A'; // Assuming 'name' is a field in Plans
                    })

                    ->rawColumns(['planname','product_category_name','productname'])->make(true);
        }
        return view('agents.failed.index');

    }
    public function subreport(Request $request)
    {
        $agent = session('agent');
        $agentId = $agent->id;
        if ($request->ajax()) {
            $data = Subscription::select('*')->where('agent_id',$agentId)->where('policy_status',1)->orderBy('created_at', 'desc');
            return Datatables::of($data)->addIndexColumn()

                    ->addColumn('product_category_name', function($data){
                        return $data->categories ? $data->categories->category_name : 'N/A'; // Assuming 'name' is a field in Categories
                    })
                    ->addColumn('planname', function($data){
                        return $data->plan ? $data->plan->plan_name : 'N/A'; // Assuming 'name' is a field in Plans
                    })
                    ->addColumn('productname', function($data){
                        return $data->products ? $data->products->product_name : 'N/A'; // Assuming 'name' is a field in Plans
                    })

                    ->rawColumns(['planname','product_category_name','productname'])->make(true);
        }

        return view('agents.sub.index');

    }

}
