<?php

namespace App\Http\Controllers\agent;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ControlledUser;
use App\Models\AgentData;
use Carbon\Carbon;
use App\Models\TLName;
use App\Models\Disposition;
use Illuminate\Support\Facades\Auth;

class AgentAuthController extends Controller
{
    public function showLoginForm()
    {

        return view('agents.login');
    }

    /**
     * Handle agent login.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function login(Request $request)
    {
        $credentials = $request->validate([
            'username' => 'required|string',
            'password' => 'required|string',
        ]);


        // Attempt to authenticate the agent
        $agent = ControlledUser::where('username', $request->username)->first();
    //    dd($agent);

        if ($agent && $agent->is_active == 0) {
            return redirect()->back()->withInput()->withErrors(['login' => 'Your account is disabled.']);
        }
    if ($agent && $agent->role == "agent") {
    if ($agent && $agent->is_active == 1 && Auth::guard('agent')->attempt($credentials)) {

        // Authentication successful, update login details and redirect to the agent dashboard
        //  dd($agent);
        $id = $agent->id;
        $agent = Auth::guard('agent')->user();

        $agentupdate = ControlledUser::find($id);
        $agentupdate->last_login_at = now();
        $agentupdate->is_login = "1";
        $agentupdate->update();

        session(['agent' => $agent]);

        if (auth()->guard('agent')->check()) {
            return redirect()->route('agents.dashboards');
        }

        // if ($agent && $agent->role == 'reporter') {
        //     if (auth()->guard('agent')->check()) {
        //         return redirect()->route('reporter.dashboard');
        //     }
        // }

        }
        else{
            return redirect()->back()->withInput()->withErrors(['login' => 'Invalid credentials, Kindly Check Your Username & Password, Password is Case Sensitive']);
        }
    }
    else{
        return redirect()->back()->withInput()->withErrors(['login' => 'Invalid credentials, Kindly Check Your Username & Password, Password is Case Sensitive']);

    }



}

public function showDashboard()
{

    $agent = session('agent');


    $datas = TLName::where('status',1)->get();
    $disposition = Disposition::where('status',1)->get();

    if (!$agent) {

        return redirect()->back()->withInput()->withErrors(['login' => 'Session Expired Kindly Re-login']);
    }
    else{


    return view('agents.deshboard',compact('datas','disposition'));
    }

}
public function logout(Request $request)
{
    // dd($request->all());
    Auth::guard('agent')->logout();
     $agentupdate = ControlledUser::where('username', $request->username)->first();
    $agentupdate->is_login = "0";
    $agentupdate->update();
    return redirect()->route('agent.login');
}

public function store(Request $request)
{
//    dd($request->all());
   $request->validate([
    'agent_hd' => 'required',
    'agent_name' => 'required',
    'tid_number' => 'required',
    'msisdn' => 'required',
    'tl_name' => 'required',
    'agent_id' => 'required',
    'disposition' => 'required',
    'comment' => 'required',

]);
  $agent_data   = new AgentData();
  $agent_data->agent_hd = $request->agent_hd;
  $agent_data->agent_name = $request->agent_name;
  $agent_data->tid_number = $request->tid_number;
  $agent_data->msisdn = $request->msisdn;
  $agent_data->tl_name = $request->tl_name;
  $agent_data->agent_id = $request->agent_id;
  $agent_data->disposition = $request->disposition;
  $agent_data->comment = $request->comment;
 $agent_data->save();
return redirect()->route('agents.dashboards')->with('success','Successfully Request Submitted !');

}



}
