<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Yajra\DataTables\DataTables;
use App\Models\ControlledUser;
use App\Models\TLName;
use App\Models\Disposition;
use Illuminate\Support\Facades\Hash;
use App\Models\AgentData;



class UserController extends Controller
{

    public function create()
    {
        return view('admin.users.create');
    }
    public function index(Request $request)
    {

        if ($request->ajax()) {
            $data = ControlledUser::select('*')->orderBy('created_at', 'desc');
            return Datatables::of($data)->addIndexColumn()
             ->addColumn('action', function($data){
                           return '

                           ';
                    })
                    ->addColumn('is_active', function($data) {
                        return $data->is_active == 1 ? 'Active User' : 'In Active User';
                    })
                    ->addColumn('is_login', function($data) {
                        return $data->is_login == 1 ? 'Login User' : 'Logout User';
                    })
                    ->rawColumns(['action','is_active','is_login'])->make(true);

        }
        return view('admin.users.index');

    }
    public function store(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'first_name' => 'required',
            'last_name' => 'required',
            'email' => 'required|email|unique:controlled_users,email',
            'username' => 'required|unique:controlled_users,username',
            'password' => 'required',
        ]);
          $controlled_users   = new ControlledUser();
          $controlled_users->first_name = $request->first_name;
          $controlled_users->last_name = $request->last_name;
          $controlled_users->email = $request->email;
          $controlled_users->username = $request->username;
          $controlled_users->password = Hash::make($request->input('password'));
          $controlled_users->role = "agent";
          $controlled_users->registration_date = now();
          $controlled_users->is_active = "1";
        $controlled_users->save();
       return redirect()->route('superadmin.index')->with('success','Successfully User Add !');
    }


    public function  showData(Request $request)
    {

        if ($request->ajax()) {
            $data = AgentData::select('*')->orderBy('created_at', 'desc');
            return Datatables::of($data)
            ->addIndexColumn()
            ->editColumn('created_at', function ($row) {
                return \Carbon\Carbon::parse($row->created_at)->format('Y-m-d');
            })
            ->make(true);

        }


    }

    public function edit($id)
    {
        $user = ControlledUser::find($id);
        return view('admin.users.edit', compact('user'));
    }

    public function update(Request $request)
    {
        // dd($request->all());

        $controlled_users   = ControlledUser::find($request->id);
        $controlled_users->username = $request->username;
        if(!empty($request->password)){
            $controlled_users->password = Hash::make($request->input('password'));
        }
        $controlled_users->employee_code = $request->employee_code;
        $controlled_users->role = $request->role;
        $controlled_users->is_active = $request->is_active;
        $controlled_users->update();

       return redirect()->route('admin.index')->with('success','Successfully User Updated !');
    }

    public function teamleadindex(Request $request)
{
    if ($request->ajax()) {
        $data = TLName::select('*')->orderBy('created_at', 'desc');
        return Datatables::of($data)
            ->addIndexColumn()
            ->editColumn('created_at', function ($row) {
                return \Carbon\Carbon::parse($row->created_at)->format('Y-m-d');
            })
            ->make(true);
    }

    return view('admin.users.teamlead');
}


    public function teamleadstore(Request $request)
    {
        $request->validate([
            'name' => 'required',

        ]);
          $team_lead   = new TLName();
          $team_lead->name = $request->name;
          $team_lead->status = "1";
          $team_lead->save();
       return redirect()->route('teamlead.index')->with('success','Successfully  Add !');
    }


    public function dispositionindex(Request $request)
    {
        if ($request->ajax()) {
            $data = Disposition::select('*')->orderBy('created_at', 'desc');
            return Datatables::of($data)
                ->addIndexColumn()
                ->editColumn('created_at', function ($row) {
                    return \Carbon\Carbon::parse($row->created_at)->format('Y-m-d');
                })
                ->make(true);
        }

        return view('admin.users.disposition');
    }


        public function dispositionstore(Request $request)
        {
            $request->validate([
                'name' => 'required',

            ]);
              $team_lead   = new Disposition();
              $team_lead->name = $request->name;
              $team_lead->status = "1";
              $team_lead->save();
           return redirect()->route('disposition.index')->with('success','Successfully  Add !');
        }




}
