<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;



class AdminAuthController extends Controller
{
    protected $redirectTo = '/admin/dashboard';

    public function showLoginForm()
    {
        return view('admin.login');
    }

    public function login(Request $request)
    {
        // dd($request->all());
        $request->validate([
            'username' => 'required',
            'password' => 'required',
        ]);

        if (Auth::guard('admin')->attempt($request->only('username', 'password'))) {

            $Superadmin = Auth::guard('admin')->user();

            session(['admin' => $Superadmin]);
            return redirect()->route('admin.dashboard');

        }

        return redirect()->back()->withInput()->withErrors(['login' => 'Invalid credentials, Kindly Check Your Username & Password, Password is Case Sensitive']);


    }

    public function showDashboard()
    {

        return view('admin.deshboard');
    }
    public function logout()
    {
        Auth::guard('admin')->logout();
        return redirect()->route('superadmin.login');
    }
}
